# 画面設計書 47-フォームレイアウト（Bootstrap 4）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 4対応のフォームレイアウトテーマ（bootstrap_4_layout.html.twig）の画面設計書である。bootstrap_base_layoutを基盤として、Bootstrap 4のCSSクラスとコンポーネント構造を適用したフォーム要素のレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：Bootstrap 4はBootstrap 3からの大幅なアップデートで、Flexboxレイアウト、カスタムフォーム要素（custom-control）、form-check、is-invalidクラスベースのバリデーション表示など多くの変更が加えられた。bootstrap_4_layoutはこれらの変更に対応し、Bootstrap 4のデザインシステムに準拠したフォームレンダリングを提供する。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_4_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. テキスト入力にform-controlクラスを適用（file→custom-file-input、range→form-control-range）
2. バリデーションエラー時にis-invalidクラスを適用（Bootstrap 3のhas-errorから変更）
3. ボタンにbtn-secondaryおよびbtnクラスを適用（Bootstrap 3のbtn-defaultから変更）
4. 送信ボタンにbtn-primaryクラスを適用
5. チェックボックスをform-check/custom-control/custom-switchの3パターンで対応
6. ラジオボタンをform-check/custom-controlの2パターンで対応
7. ファイル入力をcustom-file構造でレンダリング
8. エラー表示をinvalid-feedback/alert-dangerクラスのspan/divで表示（badge付き）
9. ヘルプテキストをform-text text-mutedクラスのsmall要素で表示
10. ラベルにcol-form-labelクラスを適用（compoundフォームではlegend要素を使用）
11. 日付/時刻/日時/期間ウィジェットのバリデーション時にis-invalidクラスを自動適用

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 4対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 4用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_4_layout.html.twig']
```

## 入出力項目

form_div_layoutと同一の共通変数に加え、以下のBootstrap 4固有変数を使用する。

| 変数名 | 型 | 説明 |
|--------|------|------|
| valid | bool | バリデーション結果（falseでis-invalidクラス適用） |
| parent_label_class | string | 親ラベルのCSSクラス（checkbox-custom/radio-custom/switch-custom判定用） |
| widget | string | チェックボックス/ラジオのwidgetブロック出力 |
| group_class | string | input-groupの追加クラス |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | Bootstrap 4適用クラス | 説明 |
|-----------|---------------------|------|
| form_widget_simple | `form-control` / `custom-file-input` / `form-control-range` | テキスト/ファイル/レンジ入力 |
| widget_attributes | `is-invalid` | バリデーションエラー時の属性 |
| button_widget | `btn-secondary btn` | ボタン要素 |
| submit_widget | `btn-primary` | 送信ボタン |
| money_widget | `input-group` / `input-group-prepend/append` / `input-group-text` | 通貨記号付き入力 |
| percent_widget | `input-group` / `input-group-append` / `input-group-text` | パーセント記号付き入力 |
| file_widget | `custom-file` / `custom-file-input` / `custom-file-label` | ファイル入力 |
| checkbox_widget | `form-check-input` / `custom-control-input` | チェックボックス（通常/カスタム/スイッチ） |
| radio_widget | `form-check-input` / `custom-control-input` | ラジオボタン（通常/カスタム） |
| choice_widget_collapsed | `form-control` | セレクト要素 |
| form_label | `col-form-label` | ラベル（compoundではlegend要素） |
| form_label_errors | `invalid-feedback` | ラベル内エラー表示 |
| form_row | `form-group` | フォーム行（fieldsetでcompound対応） |
| form_errors | `invalid-feedback` / `alert alert-danger` / `badge badge-danger` | エラー表示 |
| form_help | `form-text text-muted` | ヘルプテキスト（small要素） |
| datetime_widget | `form-control is-invalid` | 日時ウィジェットのバリデーション対応 |
| date_widget | `form-control is-invalid` | 日付ウィジェットのバリデーション対応 |
| time_widget | `form-control is-invalid` | 時刻ウィジェットのバリデーション対応 |
| dateinterval_widget | `form-control is-invalid` / `form-inline` / `col-auto` | 期間ウィジェット |

## イベント仕様

### 1-Bootstrap 4スタイルでのフォームレンダリング

主なHTML出力例：
```html
<!-- 通常フィールド -->
<div class="form-group">
    <label class="col-form-label" for="form_name">Name</label>
    <input type="text" class="form-control is-invalid" id="form_name" aria-invalid="true" />
    <small class="form-text text-muted">Enter your name</small>
    <span class="invalid-feedback d-block">
        <span class="d-block">
            <span class="form-error-icon badge badge-danger text-uppercase">Error</span>
            <span class="form-error-message">This value is required.</span>
        </span>
    </span>
</div>

<!-- カスタムチェックボックス -->
<div class="custom-control custom-checkbox">
    <input type="checkbox" class="custom-control-input" id="form_agree" />
    <label class="custom-control-label" for="form_agree">I agree</label>
</div>
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|-------------|------|-------------|
| バリデーションエラー | errors が存在する場合 | badge badge-danger付きのエラーメッセージ（"Error"ラベルはvalidatorsドメインで翻訳） |

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_base_layout.html.twig' %}`により、Bootstrap共通基盤テーマを利用
- Bootstrap 3からの主な変更点：has-error→is-invalid、btn-default→btn-secondary、help-block→form-text、glyphicon→badge
- カスタムフォーム要素（custom-control、custom-file、custom-switch）はBootstrap 4固有の機能
- file_widgetでは`app.request.locale`を使用してlang属性を動的に設定
- compound要素ではlabel要素の代わりにlegend要素を使用し、col-form-labelクラスを適用
- form_label_errorsブロックが新設され、ラベル要素内にエラーを表示する構造になっている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テーマのチェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマ |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通基盤テーマ |

#### Step 3: Bootstrap 4固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_4_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` | Bootstrap 4固有のブロック定義を理解する |

**主要処理フロー**:
1. **L5-25**: `money_widget` - input-group-prepend/appendによる通貨記号表示
2. **L27-49**: `datetime_widget`/`date_widget`/`time_widget` - バリデーション時のis-invalidクラス適用
3. **L108-119**: `percent_widget` - input-group-appendによるパーセント記号表示
4. **L121-135**: `file_widget` - custom-file構造によるファイル入力
5. **L137-152**: `form_widget_simple` - form-control/custom-file-input/form-control-rangeの振り分け
6. **L154-159**: `widget_attributes` - is-invalidクラスの条件付き適用
7. **L161-169**: `button_widget`/`submit_widget` - btn-secondary/btn-primaryの適用
8. **L171-204**: `checkbox_widget` - form-check/custom-control/custom-switchの3パターン分岐
9. **L225-246**: `form_label` - col-form-label適用、compound→legend要素
10. **L281-298**: `form_row` - form-group適用、compound→fieldset要素
11. **L302-312**: `form_errors` - invalid-feedback/alert-danger + badge表示
12. **L316-323**: `form_help` - form-text text-muted付きsmall要素

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [bootstrap_4_layout オーバーライド]
    |       +-- <div class="form-group"> or <fieldset class="form-group">
    |       +-- form_label [bootstrap_4_layout オーバーライド]
    |       |       +-- <label class="col-form-label"> or <legend class="col-form-label">
    |       |       +-- form_label_errors [bootstrap_4_layout 新設]
    |       +-- form_widget
    |       |       +-- form_widget_simple [bootstrap_4_layout オーバーライド]
    |       |               +-- <input class="form-control is-invalid" />
    |       +-- form_help [bootstrap_4_layout オーバーライド]
    |       |       +-- <small class="form-text text-muted">
    |       +-- </div> or </fieldset>
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
                    テーマ検索順序:                     |
                    1. bootstrap_4_layout              v
                    2. bootstrap_base_layout     Bootstrap 4 CSSクラス付きHTML
                    3. form_div_layout           (<div class="form-group">,
                                                  <input class="form-control">,
                                                  <span class="invalid-feedback">,
                                                  <small class="form-text">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_4_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` | テンプレート | Bootstrap 4対応フォームテーマ（全324行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
